#include <iostream>
#include <vector>
#include <string>
using namespace std;

// p1: Write a function that receives a string containing a 16-bit binary 
// integer. The function must return the string's integer value.

int binStrToInt32(string s) {
	int num = 0;     
    for(int i = 0; s[i] >= '0' && s[i] <= '1'; i++) {
       num = num * 2 + s[i]-'0';
	}
    return num;
}	

// p2: Write a function that receives a string containing a 32-bit 
// hexadecimal integer. The function must return the string's 
// integer value.

int hexStrToInt32(string s) {
	int num = 0;     
    for(int i = 0; ; i++) {
		if( s[i] >= '0' && s[i] <= '9' )
			num = num * 16 + s[i]-'0';
		else if( s[i] >= 'A' && s[i] <= 'F' )
			num = num * 16 + (s[i]-'A'+10);
		else
			break;
	}
    return num;
}	

// p3: Write a function that receives an integer. The function 
// must return a string containing the binary representation 
// of the integer.

string intToBinStr( int n )  {
	vector<int> stack;
	
	do {
		int quotient = n / 2;
		int remainder = n % 2;
		stack.push_back(remainder);
		n = quotient;
	} while( n > 0 );

	string s;
	while( stack.size() > 0 ) {
		s += (stack.back() + '0');
		stack.pop_back();
	}
	return s;
}

// p4: Write a function that receives an integer. The function 
// must return a string containing the hexadecimal representation 
// of the integer.

string intToHexStr( int n )  {
	vector<int> stack;
	
	do {
		int quotient = n / 16;
		int remainder = n % 16;
		stack.push_back(remainder);
		n = quotient;
	} while( n > 0 );

	string s;
	while( stack.size() > 0 ) {
		int d = stack.back();
		if( d >= 0 && d <= 9 )
			s += (stack.back() + '0');
		else // probably a hex digit
			s += (stack.back() - 10 + 'A');
		stack.pop_back();
	}
	return s;
}

// p5: Write a function that adds two digit strings in base 
// b, where 2 <= b <= 10. Each string may be as long as one 
// million digits, and strings must be of equal length. 
// Return the sum in a string that uses the same number base.

string addDigitStrings( string & s1, string & s2, int base ) {
	string sumStr;
	int carry = 0;

	for(int i = s1.size() - 1; i >= 0; i--) {
		int dval = (s1[i] - '0') + (s2[i] - '0') + carry;
		carry = 0;
		if( dval > (base - 1) ) {
			carry = 1;
			dval = dval % base;
		}
		sumStr.insert(sumStr.begin(), (dval + '0'));
	}
	if( carry == 1 )
		sumStr.insert( sumStr.begin(), 1 + '0');
	return sumStr;
}


void main() {

	/* // p5
	cout << addDigitStrings("011", "001", 2) << endl;  // 100
	cout << addDigitStrings("22", "34", 5) << endl;  // 111
	cout << addDigitStrings("29", "34", 7) << endl;  //  166
	cout << addDigitStrings("22", "35", 10) << endl;  // 57
	cout << addDigitStrings("88", "22", 10) << endl;  // 110
	cout << addDigitStrings("97688", "07842", 10) << endl;  // 105530
	*/

	/*  // p4
	cout << intToHexStr(64) << endl;   // 40
	cout << intToHexStr(26) << endl;   // 1A
	cout << intToHexStr(11) << endl;   // B
	cout << intToHexStr(65535) << endl;   // FFFF
	*/
	
	// p3
	//cout << intToBinStr(32769) << endl;

	// p2
	//cout << hexStrToInt32("FFFFFFFF") << endl;

	// p1
	//cout << binStrToInt32("0000111100001101") << endl;
	//cout << binStrToInt32("1011") << endl;

}